
#include<iostream>
#include<windows.h>
#include<stdio.h>
#include<string.h>
#include "QCAP.H"


using namespace std;


#define  RETURN_FAIL 0
#define  RETURN_OK 1

#define  MAX_CHANNEL_NUM 4

#define  MAX_VIDEO_INPUT_NUM 8
#define  MAX_AUDIO_INPUT_NUM 4

#define  DEF_SHARERECORD_UNUSE -1

char input_video_mapping[MAX_VIDEO_INPUT_NUM][12] = {"COMPOSITE", "SVIDEO", "HDMI", "DVI-D", "COMPONENTS", "DVI-A", "SDI", "AUTO"};

char input_audio_mapping[MAX_AUDIO_INPUT_NUM][24] = {"EMBEDDED_AUDIO", "LINE_IN", "SOUNDCARD_MICROPHONE", "SOUNDCARD_LINE_IN"};

int get_audio_format_by_mapping[2] = {QCAP_ENCODER_FORMAT_AAC, QCAP_ENCODER_FORMAT_PCM};


typedef struct CaputreStatus_s
{
	BOOL  m_bIsRecord_flag;
	BOOL  m_bNoSignal_flag;
	BOOL  m_Deinterlace_flag;
	BOOL  m_ShareRecord_flag;

}CaputreStatus_t;


class CaptureCard
{

public:

	PVOID  m_hVideoDevice;

	ULONG  m_nVideoWidth;

	ULONG  m_nVideoHeight;

	ULONG  m_nVideoInput;

	ULONG  m_nAudioInput;

	double  m_dVideoFrameRate;

// Status 
	CaputreStatus_t m_status;

    QRESULT m_errno;

};


class MainControl_Class
{

public:

	void   show_information();

	int    init_capture_card_func();

	int    file_record_start_func(struct command_s command_data);

	int    file_record_stop_func(struct command_s command_data);

	int    share_record_start_func(struct command_s command_data);

	int    share_record_stop_func();

	int    snapshot_jpg_func(struct command_s command_data);

	int    snapshot_bmp_func(struct command_s command_data);

	int    set_video_input_func(struct command_s command_data);

	int    set_audio_input_func(struct command_s command_data);

	void   OnDestroy();

private:

	CaptureCard m_capture_card[MAX_CHANNEL_NUM];

	int  m_share_record_idx;
	
};